<?php
/**
 * Filters
 *
 * @package     AutomatorWP\User_Lists\Filters
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Detect when a user is added to a list
 *
 * @since 1.0.0
 */
function automatorwp_user_lists_on_add_user_to_list( $object_id, $object, $update ) {

    global $ct_table;

    if( $ct_table->name !== 'automatorwp_user_lists_users' ) {
        return;
    }

    $list_user = ct_get_object( $object_id );

    do_action( 'automatorwp_user_lists_user_added_to_list', $list_user->list_id, $list_user->user_id, $list_user );

}
add_action( 'ct_insert_object', 'automatorwp_user_lists_on_add_user_to_list', 10, 3 );

/**
 * Detect when a user is removed from a list
 *
 * @since 1.0.0
 */
function automatorwp_user_lists_on_remove_user_to_list( $object_id ) {

    global $ct_table;

    if( $ct_table->name !== 'automatorwp_user_lists_users' ) {
        return;
    }

    $list_user = ct_get_object( $object_id );

    do_action( 'automatorwp_user_lists_user_removed_from_list', $list_user->list_id, $list_user->user_id, $list_user );

}
add_action( 'before_delete_object', 'automatorwp_user_lists_on_remove_user_to_list' );

/**
 * Detect when a list is removed to delete all relationships
 *
 * @since 1.0.0
 */
function automatorwp_user_lists_on_remove_list( $object_id ) {

    global $wpdb, $ct_table;

    if( $ct_table->name !== 'automatorwp_user_lists' ) {
        return;
    }

    // Setup table
    $ct_table = ct_setup_table( 'automatorwp_user_lists_users' );

    // Delete all users entries in this list
    $wpdb->query( "DELETE FROM {$ct_table->db->table_name} WHERE list_id = {$object_id}" );

    ct_reset_setup_table();
}
add_action( 'before_delete_object', 'automatorwp_user_lists_on_remove_list' );
